<?php
$page_title = 'Pengaturan';
include 'includes/header.php';
?>

<div class="container">
    <div class="card">
        <h2>📱 Install Aplikasi</h2>
        <p style="color:var(--text-secondary);margin-bottom:20px;">
            Install aplikasi ini di HP untuk akses cepat seperti app native!
        </p>

        <button id="installBtn" class="btn btn-success btn-full">
            <span>📲</span>
            Install Aplikasi Sekarang
        </button>

        <p id="installStatus" style="text-align:center;margin-top:15px;color:var(--text-secondary);"></p>
    </div>

    <div class="card">
        <h2>💾 Manajemen Backup</h2>
        <p style="color:var(--text-secondary);margin-bottom:20px;">
            Backup dan restore data aplikasi Anda dengan mudah
        </p>

        <a href="backup.php" style="text-decoration:none;">
            <button class="btn btn-success btn-full">
                <span>📦</span>
                Buka
            </button>
        </a>
    </div>

    <div class="card">
        <h2>🔐 Keamanan</h2>
        <p style="color:var(--text-secondary);margin-bottom:20px;">
            Kelola sandi akses halaman Anda
        </p>

        <a href="change_password.php" style="text-decoration:none;">
            <button class="btn btn-success btn-full">
                <span>🔑</span>
                Ganti Sandi Halaman
            </button>
        </a>
    </div>

<?php include 'includes/footer.php'; ?>

<script>
    let deferredPrompt;
    let isInstallPromptShown = false;

    // Detect PWA support
    window.addEventListener('beforeinstallprompt', (e) => {
        e.preventDefault();
        deferredPrompt = e;
        isInstallPromptShown = true;
        document.getElementById('installStatus').textContent = '✅ Siap diinstall!';
        document.getElementById('installBtn').disabled = false;
    });

    // Check if app is already installed
    window.addEventListener('appinstalled', () => {
        deferredPrompt = null;
        isInstallPromptShown = false;
        document.getElementById('installStatus').textContent = '✅ Aplikasi sudah terinstall!';
        document.getElementById('installBtn').disabled = true;
    });

    // Check on page load if app is installed or PWA is not supported
    window.addEventListener('load', () => {
        setTimeout(() => {
            if (!isInstallPromptShown) {
                if (window.navigator.standalone === true) {
                    // Running as standalone PWA
                    document.getElementById('installStatus').textContent = '✅ Aplikasi sudah terinstall!';
                    document.getElementById('installBtn').disabled = true;
                } else {
                    // PWA not supported or already installed
                    document.getElementById('installStatus').textContent = '⚠️ Browser tidak mendukung PWA\\nGunakan Chrome/Edge/Safari terbaru';
                    document.getElementById('installBtn').disabled = true;
                }
            }
        }, 500);
    });

    document.getElementById('installBtn').addEventListener('click', async () => {
        if (!deferredPrompt || !isInstallPromptShown) {
            alert('Browser tidak mendukung PWA atau sudah terinstall.\\n\\nGunakan Chrome/Safari dengan HTTPS dan terbuka di domain yang sama.');
            return;
        }

        try {
            deferredPrompt.prompt();
            const { outcome } = await deferredPrompt.userChoice;

            if (outcome === 'accepted') {
                document.getElementById('installStatus').textContent = '🎉 Berhasil diinstall! Restart aplikasi.';
                deferredPrompt = null;
                isInstallPromptShown = false;
                document.getElementById('installBtn').disabled = true;
            }
        } catch (error) {
            console.error('Install error:', error);
            alert('Gagal install: ' + error.message);
        }
    });
</script>