<?php
// ========== ANTI CACHE - SOLUSI DATA HILANG ==========
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
// =====================================================

$page_title = 'Total Saldo';
include 'includes/header.php';
?>

<div class="container">
    <div class="card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 0.1px; text-align: center;">
        <div style="margin-bottom: 15px;">
            <div style="font-size: 0.85em; opacity: 0.9; margin-bottom: 5px;">💰 Total Saldo Keseluruhan</div>
            <div style="font-size: 1.5em; font-weight: bold; margin-bottom: 1px; word-break: break-word;" id="totalSaldoDisplay">Rp 0</div>
            
        </div>
    </div>
   

    <!-- Tombol Lihat Selengkapnya -->
    <div style="text-align: center; margin: 15px 0;">
        <button onclick="toggleDetailContainer()" style="padding: 10px 25px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; font-size: 0.95em;">
            ▼ Lihat Selengkapnya
        </button>
    </div>

    <!-- Detail Container...

    <!-- Detail Container (LANGSUNG TERBUKA - TIDAK HIDDEN) -->
  <div id="saldoDetailContainer" style="margin-top: 10px; display: none;">

        <!-- Pemasukan -->
      <div class="card" style="background: linear-gradient(135deg, #667eea 100%, #764ba2 100%); color: white; padding: 0.1px; text-align: Left;">
        <div style="margin-bottom: 15px;">
        <div class="card" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 10px; margin-bottom: 5px;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
                <div style="flex: 1; min-width: 100px;">
                    <div style="font-size: 0.75em; opacity: 0.9; margin-bottom: 5px;">📈 Total Pemasukan Keseluruhan</div>
                    <div style="font-size: 1em; font-weight: bold; word-break: break-word;" id="totalIncomeDisplay">Rp 0</div>
                </div>
                <div style="font-size: 3em; opacity: 0.3;"></div>
            </div>
        </div>

        <!-- Pengeluaran -->
        <div class="card" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; padding: 10px; margin-bottom: 5px;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
                <div style="flex: 1; min-width: 200px;">
                    <div style="font-size: 0.75em; opacity: 0.9; margin-bottom: 5px;">📉 Total Pengeluaran Keseluruhan</div>
                    <div style="font-size: 1em; font-weight: bold; word-break: break-word;" id="totalExpenseDisplay">Rp 0</div>
                </div>
                <div style="font-size: 3em; opacity: 0.3;"></div>
            </div>
        </div>

        <!-- Jumlah Transaksi -->
        <div class="card" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 10px; margin-bottom: 5px;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
                <div style="flex: 1; min-width: 200px;">
                    <div style="font-size: 0.75em; opacity: 0.9; margin-bottom: 5px;">📋 Transaksi Tercatat Keseluruhan</div>
                    <div style="font-size: 1em; font-weight: bold; word-break: break-word;" id="totalTransactionCount">0</div>
                </div>
                <div style="font-size: 3em; opacity: 0.3;"></div>
            </div>
        </div>
</div>
 </div>
  </div>
   </div>
        <!-- Breakdown per Tahun dengan Dropdown Pilihan -->
        <div class="card">
            <h2>📊 Lihat Per Tahun</h2>
            <div style="margin-bottom: 15px;">
                <select id="yearBreakdownYear" style="width: 100%; padding: 12px; border: 2px solid var(--border); border-radius: 8px; font-size: 1em;">
                    <option value="">Pilih Tahun</option>
                </select>
            </div>
            <div id="yearBreakdownContainer" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;"></div>
        </div>

        <!-- Breakdown per Bulan (Tahun Terpilih) -->
        <div class="card">
            <h2>📅 Lihat Per Bulan</h2>
            <div style="margin-bottom: 15px;">
                <select id="monthBreakdownYear" style="width: 100%; padding: 12px; border: 2px solid var(--border); border-radius: 8px; font-size: 1em;">
                    <option value="">Pilih Tahun</option>
                </select>
            </div>
            <div id="monthBreakdownContainer" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;"></div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>

<script>
    // FORMAT CURRENCY - TANPA SINGKATAN (Rp 1.000.000, bukan Rp 1 jt)
    function formatCurrency(amount) {
        return 'Rp ' + Math.floor(amount).toLocaleString('id-ID');
    }

    let transactions = [];
    const months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];

    // UPDATE TOTAL SALDO
    function updateTotalSaldo() {
        const totalIncome = transactions
            .filter(t => t.type === 'income')
            .reduce((sum, t) => sum + t.amount, 0);
        
        const totalExpense = transactions
            .filter(t => t.type === 'expense')
            .reduce((sum, t) => sum + t.amount, 0);
        
        const totalSaldo = totalIncome - totalExpense;

        document.getElementById('totalSaldoDisplay').textContent = formatCurrency(totalSaldo);
        document.getElementById('totalIncomeDisplay').textContent = formatCurrency(totalIncome);
        document.getElementById('totalExpenseDisplay').textContent = formatCurrency(totalExpense);
        document.getElementById('totalTransactionCount').textContent = transactions.length + ' transaksi';

        // Update breakdown
        populateYearDropdowns();
    }

    // POPULATE YEAR DROPDOWNS (untuk kedua section)
    function populateYearDropdowns() {
        const years = [...new Set(transactions.map(t => new Date(t.date).getFullYear()))].sort().reverse();
        
        const yearBreakdownDropdown = document.getElementById('yearBreakdownYear');
        const monthBreakdownDropdown = document.getElementById('monthBreakdownYear');
        
        // Populate breakdown per tahun dropdown
        yearBreakdownDropdown.innerHTML = '<option value="">Pilih Tahun</option>' +
            years.map(y => `<option value="${y}">${y}</option>`).join('');

        // Populate breakdown per bulan dropdown
        monthBreakdownDropdown.innerHTML = '<option value="">Pilih Tahun</option>' +
            years.map(y => `<option value="${y}">${y}</option>`).join('');

        // Auto-select tahun terbaru untuk breakdown per bulan
        if (years.length > 0) {
            monthBreakdownDropdown.value = years[0];
            updateMonthBreakdown();
        }

        // Auto-select tahun terbaru untuk breakdown per tahun
        if (years.length > 0) {
            yearBreakdownDropdown.value = years[0];
            updateYearBreakdown();
        }
    }
function updateYearBreakdown() {
    const selectedYear = document.getElementById('yearBreakdownYear').value;
    
    if (!selectedYear) {
        document.getElementById('yearBreakdownContainer').innerHTML = 
            '<p style="text-align: center; color: var(--text-secondary); grid-column: 1 / -1;">Pilih tahun untuk melihat detail</p>';
        return;
    }

    // ========== HANYA HITUNG TOTAL TAHUN ==========
    let yearIncome = 0;
    let yearExpense = 0;

    transactions
        .filter(t => new Date(t.date).getFullYear() === parseInt(selectedYear))
        .forEach(trans => {
            if (trans.type === 'income') {
                yearIncome += trans.amount;
            } else if (trans.type === 'expense') {
                yearExpense += trans.amount;
            }
        });

    const yearBalance = yearIncome - yearExpense;

    // ========== TAMPILKAN DALAM FORMAT BOX (SEPERTI OKTOBER 2025) ==========
    const container = document.getElementById('yearBreakdownContainer');
    
    let html = `
        <div style="background: var(--bg); padding: 20px; border-radius: 8px; border-left: 5px solid #10b981; margin-bottom: 15px; grid-column: 1 / -1;">
            <div style="margin-bottom: 12px;">
                <div style="font-size: 1.1em; font-weight: bold; color: var(--text); margin-bottom: 12px;">Total Tahun ${selectedYear}</div>
                
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                    <span style="color: var(--text-secondary); font-size: 0.9em;">Pemasukan:</span>
                    <strong style="color: #10b981; font-size: 0.95em; word-break: break-word;">${formatCurrency(yearIncome)}</strong>
                </div>
                
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                    <span style="color: var(--text-secondary); font-size: 0.9em;">Pengeluaran:</span>
                    <strong style="color: #ef4444; font-size: 0.95em; word-break: break-word;">-${formatCurrency(yearExpense)}</strong>
                </div>
                
                <div style="display: flex; justify-content: space-between; align-items: center; padding-top: 8px; border-top: 1px solid var(--border);">
                    <span style="color: var(--text-secondary); font-size: 0.9em;">Saldo:</span>
                    <strong style="color: ${yearBalance >= 0 ? '#10b981' : '#ef4444'}; font-size: 0.95em; word-break: break-word;">${formatCurrency(yearBalance)}</strong>
                </div>
            </div>
        </div>
    `;

    container.innerHTML = html;
}


    // UPDATE MONTH BREAKDOWN
    function updateMonthBreakdown() {
        const year = document.getElementById('monthBreakdownYear').value;
        
        if (!year) {
            document.getElementById('monthBreakdownContainer').innerHTML = 
                '<p style="text-align: center; color: var(--text-secondary); grid-column: 1 / -1;">Pilih tahun untuk melihat breakdown per bulan</p>';
            return;
        }

        const monthData = {};

        transactions
            .filter(t => new Date(t.date).getFullYear() === parseInt(year))
            .forEach(trans => {
                const month = new Date(trans.date).getMonth();
                if (!monthData[month]) {
                    monthData[month] = { income: 0, expense: 0, count: 0 };
                }
                if (trans.type === 'income') {
                    monthData[month].income += trans.amount;
                } else {
                    monthData[month].expense += trans.amount;
                }
                monthData[month].count++;
            });

        const container = document.getElementById('monthBreakdownContainer');
        let html = '';

      for (let i = 11; i >= 0; i--) {
            const data = monthData[i];
            if (!data) continue;

            const balance = data.income - data.expense;
            const color = balance >= 0 ? '#10b981' : '#ef4444';

       html += `
    <div style="background: var(--bg); padding: 20px; border-radius: 12px; border-left: 5px solid ${color};">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
            <h3 style="margin: 0; color: var(--primary); font-size: 1.1em;">${months[i]} ${year}</h3>
            <button onclick="showMonthDetails(${i}, ${year})" style="padding: 6px 12px; background: #667eea; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 0.85em; font-weight: 600;">📋 Rincian</button>
        </div>
        <div style="margin-bottom: 12px;">

                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span style="color: var(--text-secondary); font-size: 0.9em;">Pemasukan:</span>
                            <strong style="color: #10b981; font-size: 0.95em; word-break: break-word;">${formatCurrency(data.income)}</strong>
                        </div>
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span style="color: var(--text-secondary); font-size: 0.9em;">Pengeluaran:</span>
                            <strong style="color: #ef4444; font-size: 0.95em; word-break: break-word;">-${formatCurrency(data.expense)}</strong>
                        </div>
                        <div style="display: flex; justify-content: space-between; padding-top: 8px; border-top: 1px solid var(--border);">
                            <span style="color: var(--text-secondary); font-size: 0.9em;">Saldo:</span>
                            <strong style="color: ${color}; font-size: 0.95em; word-break: break-word;">${formatCurrency(balance)}</strong>
                        </div>
                    </div>
                </div>
            `;
        }

        container.innerHTML = html || '<p style="text-align: center; color: var(--text-secondary); grid-column: 1 / -1;">Tidak ada data untuk tahun ini</p>';
    }

    // LOAD DATA
    async function loadData() {
        try {
            const response = await fetch('api.php?action=load');
            const data = await response.json();
            transactions = data.transactions || [];
            updateTotalSaldo();
        } catch (error) {
            console.error('Error loading data:', error);
        }
    }

    // EVENT LISTENERS
    document.getElementById('yearBreakdownYear').addEventListener('change', updateYearBreakdown);
    document.getElementById('monthBreakdownYear').addEventListener('change', updateMonthBreakdown);

    // LOAD DATA ON PAGE LOAD
    loadData();
    // FUNCTION TOGGLE DETAIL CONTAINER
function toggleDetailContainer() {
    const container = document.getElementById('saldoDetailContainer');
    const button = event.target;
    
    if (container.style.display === 'none') {
        // Buka
        container.style.display = 'block';
        button.textContent = '▲ Sembunyikan';
    } else {
        // Sembunyikan
        container.style.display = 'none';
        button.textContent = '▼ Lihat Selengkapnya';
    }
}
// ===== FUNCTION TAMPIL RINCIAN PER HARI =====
function showMonthDetails(monthIndex, year) {
    const monthName = months[monthIndex];
    
    // Filter transaksi untuk bulan tertentu
    const monthTransactions = transactions.filter(t => {
        const date = new Date(t.date);
        return date.getFullYear() === year && date.getMonth() === monthIndex;
    });

    // Group by date
    const byDate = {};
    monthTransactions.forEach(trans => {
        if (!byDate[trans.date]) {
            byDate[trans.date] = { income: [], expense: [] };
        }
        if (trans.type === 'income') {
            byDate[trans.date].income.push(trans);
        } else {
            byDate[trans.date].expense.push(trans);
        }
    });

    const dates = Object.keys(byDate).sort().reverse();
    
    // Buat detail items per hari
    let detailsContent = '';
    
    dates.forEach(date => {
        const dayData = byDate[date];
        const dayTotal = dayData.income.reduce((s, t) => s + (t.amount || 0), 0) - 
                         dayData.expense.reduce((s, t) => s + (t.amount || 0), 0);
        const dayDate = new Date(date);
        const dayName = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'][dayDate.getDay()];
        
        detailsContent += `
            <div style="background: var(--bg); padding: 15px; border-radius: 8px; margin-bottom: 15px; border-left: 4px solid ${dayTotal >= 0 ? '#10b981' : '#ef4444'};">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 12px;">
                    <div>
                        <div style="font-weight: 600; color: var(--text);">${date}</div>
                        <div style="font-size: 0.85em; color: var(--text-secondary);">${dayName}</div>
                    </div>
                    <div style="text-align: right;">
                        <div style="font-size: 0.85em; color: var(--text-secondary);">Total Hari</div>
                        <div style="font-weight: 600; color: ${dayTotal >= 0 ? '#10b981' : '#ef4444'}; font-size: 1.05em;">${formatCurrency(dayTotal)}</div>
                    </div>
                </div>
        `;
        
        // PEMASUKAN
        if (dayData.income.length > 0) {
            detailsContent += `<div style="margin-bottom: 10px; font-size: 0.85em; color: #10b981; font-weight: 600;">📈 Pemasukan (${dayData.income.length})</div>`;
            dayData.income.forEach(trans => {
                const category = trans.category || 'Pemasukan';
                const description = trans.description || 'Tidak ada keterangan';
                detailsContent += `
                    <div style="display: flex; justify-content: space-between; align-items: center; background: rgba(16, 185, 129, 0.1); padding: 8px; border-radius: 4px; margin-bottom: 5px;">
                        <div style="flex: 1;">
                            <div style="font-size: 0.9em; color: var(--text); font-weight: 600;">${category}</div>
                            <div style="font-size: 0.8em; color: var(--text-secondary);">${description}</div>
                        </div>
                        <div style="display: flex; gap: 5px; align-items: center;">
                            <span style="color: #10b981; font-weight: 600; white-space: nowrap; min-width: 90px; text-align: right;">${formatCurrency(trans.amount)}</span>
                            <button onclick="editTransactionRedirect('${trans.id}', ${monthIndex}, ${year})" style="padding: 4px 8px; background: #667eea; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 0.8em; white-space: nowrap;">✏️</button>
                        </div>
                    </div>
                `;
            });
        }
        
        // PENGELUARAN
        if (dayData.expense.length > 0) {
            detailsContent += `<div style="margin-bottom: 10px; font-size: 0.85em; color: #ef4444; font-weight: 600; margin-top: 10px;">📉 Pengeluaran (${dayData.expense.length})</div>`;
            dayData.expense.forEach(trans => {
                const category = trans.category || 'Pengeluaran';
                const description = trans.description || 'Tidak ada keterangan';
                detailsContent += `
                    <div style="display: flex; justify-content: space-between; align-items: center; background: rgba(239, 68, 68, 0.1); padding: 8px; border-radius: 4px; margin-bottom: 5px;">
                        <div style="flex: 1;">
                            <div style="font-size: 0.9em; color: var(--text); font-weight: 600;">${category}</div>
                            <div style="font-size: 0.8em; color: var(--text-secondary);">${description}</div>
                        </div>
                        <div style="display: flex; gap: 5px; align-items: center;">
                            <span style="color: #ef4444; font-weight: 600; white-space: nowrap; min-width: 90px; text-align: right;">-${formatCurrency(trans.amount)}</span>
                            <button onclick="editTransactionRedirect('${trans.id}', ${monthIndex}, ${year})" style="padding: 4px 8px; background: #667eea; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 0.8em; white-space: nowrap;">✏️</button>
                        </div>
                    </div>
                `;
            });
        }
        
        detailsContent += `</div>`;
    });
    
    // Buat modal
    const modalHTML = `
        <div style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); display: flex; align-items: center; justify-content: center; z-index: 1000; overflow-y: auto;" onclick="if(event.target === this) this.remove()">
            <div style="background: white; margin: 20px; border-radius: 12px; max-width: 600px; width: 100%; box-shadow: 0 10px 40px rgba(0,0,0,0.3);">
                
                <!-- HEADER -->
                <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <div style="font-size: 0.9em; opacity: 0.9;">📅 Rincian Detail</div>
                        <h2 style="margin: 5px 0 0 0; font-size: 1.3em;">${monthName} ${year}</h2>
                    </div>
                    <button onclick="this.closest('div').parentElement.remove()" style="background: rgba(255,255,255,0.2); border: none; color: white; font-size: 24px; width: 40px; height: 40px; border-radius: 50%; cursor: pointer;">×</button>
                </div>

                <!-- CONTENT -->
                <div style="padding: 20px; max-height: 600px; overflow-y: auto;">
                    ${detailsContent || '<p style="text-align: center; color: #999;">Tidak ada transaksi untuk bulan ini</p>'}
                </div>

                <!-- FOOTER -->
                <div style="background: #f5f5f5; padding: 15px; border-radius: 0 0 12px 12px; text-align: center; border-top: 1px solid #ddd;">
                    <button onclick="this.closest('div').parentElement.remove()" style="padding: 10px 25px; background: #667eea; color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600;">Tutup</button>
                </div>
            </div>
        </div>
    `;
    
    document.body.insertAdjacentHTML('beforeend', modalHTML);
}

// ===== FUNCTION EDIT & REDIRECT KE RIWAYAT =====
function editTransactionRedirect(transactionId, monthIndex, year) {
    window.location.href = `riwayat.php?edit=${transactionId}&month=${monthIndex}&year=${year}`;
}


</script>